-- IncreaseLightRange
--
-- # Author:  Rival
-- # date: 01.08.2020
-- # conversion to FS25 11.12.2024

Lights.onLoadFinished = Utils.appendedFunction(Lights.onLoadFinished, function(self, savegame)
	local newHighBeamRange = 65 -- this is the range for high beam light
	local newWorkLightRange = 50 -- this is the range for work lights
	
	local spec = self.spec_lights
	local function getIsHighBeam(light)
		local isHighBeam = false
		for _, lightType in pairs(light.lightTypes) do
			if lightType == 3 then
				isHighBeam = true
			else
				isHighBeam = false
				break
			end
		end
		return isHighBeam
	end
	local function getIsWorklight(light)
		local isWorklight = false
		for _, lightType in pairs(light.lightTypes) do
			if lightType == 1 or lightType == 2 then
				isWorklight = true
			else
				isWorklight = false
				break
			end
		end
		return isWorklight
	end
	for _,light in pairs(spec.realLights.low.defaultLights) do -- adjust low profile lights
		if getIsHighBeam(light) then
			if not MathUtil.getIsOutOfBounds(getLightRange(light.node), 10, newHighBeamRange-1) then
				setLightRange(light.node, newHighBeamRange)
			end
		end
		if getIsWorklight(light) then
			if not MathUtil.getIsOutOfBounds(getLightRange(light.node), 10, newWorkLightRange-1) then
				setLightRange(light.node, newWorkLightRange)
			end
		end
	end
	for _,light in pairs(spec.realLights.high.defaultLights) do -- adjust high profile lights
		if getIsHighBeam(light) then
			if not MathUtil.getIsOutOfBounds(getLightRange(light.node), 10, newHighBeamRange-1) then
				setLightRange(light.node, newHighBeamRange)
			end
			local childrenCount = getNumOfChildren(light.node)
			for i=0, childrenCount-1 do
				local child = getChildAt(light.node, i)
				if getHasClassId(child, ClassIds.LIGHT_SOURCE) then
					if not MathUtil.getIsOutOfBounds(getLightRange(child), 10, newHighBeamRange-1) then
						setLightRange(child, newHighBeamRange)
					end
				end
			end
		end
		if getIsWorklight(light) then
			if not MathUtil.getIsOutOfBounds(getLightRange(light.node), 10, newWorkLightRange-1) then
				setLightRange(light.node, newWorkLightRange)
			end
			local childrenCount = getNumOfChildren(light.node)
			for i=0, childrenCount-1 do
				local child = getChildAt(light.node, i)
				if getHasClassId(child, ClassIds.LIGHT_SOURCE) then
					if not MathUtil.getIsOutOfBounds(getLightRange(child), 10, newWorkLightRange-1) then
						setLightRange(child, newWorkLightRange)
					end
				end
			end
		end
	end
end)
